CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
    IF EXISTS (SELECT 1 FROM information_schema.columns 
                    WHERE table_name= 'v_nfce') THEN 
		DROP VIEW v_nfce;
        RAISE NOTICE 'v_nfce Dropada.';
    END IF;

	CREATE OR REPLACE VIEW v_nfce
		AS SELECT cp.cd_emp,
			cp.cd_filial,
			cp.cd_cx,
			cp.cd_vd,
			cp.dt_vd,
			cp.nr_ecf,
			cp.cd_cli,
			cp.cgc_cpf,
			cp.nm_cli,
			cp.vlr_desc,
			cp.vlr_dinh,
			cp.vlr_chqs,
			cp.vlr_troco,
			it.cd_benef,
			( SELECT COALESCE(sum(item.vl_cartao), 0::numeric) AS "coalesce"
				   FROM pdv_vd_tef item
				  WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_transacao <> 2::numeric AND item.tp_adm <> 6) AS vlr_cartao,
			( SELECT COALESCE(sum(item.vl_parc), 0::numeric) AS "coalesce"
				   FROM pdv_vd_cred item
				  WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd) AS vlr_crediario,
			cp.vlr_tickets,
			cp.vlr_conv,
			cp.vlr_dup,
			cp.vlr_ncc,
			cp.st_vd,
			cp.vlr_conv_pbm,
			( SELECT COALESCE(sum(item.vlr_liq_it), 0::numeric) AS "coalesce"
				   FROM pdv_vd_it item
				  WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_it = 1::numeric) AS vlr_to_liq_it,
			( SELECT COALESCE(sum(item.vlr_liq_it), 0::numeric) - cp.vlr_desc
				   FROM pdv_vd_it item
				  WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_it = 1::numeric) AS vlr_to_liq_vd,
			( SELECT COALESCE(sum(item.vlr_tot_it), 0::numeric) AS "coalesce"
				   FROM pdv_vd_it item
				  WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_it = 1::numeric) AS vlr_to_bruto_it,
			it.cd_it,
			it.cd_barras AS ean,
			it.cd_prod,
				CASE
					WHEN COALESCE(it.ds_prod_vd, ''::character varying)::text = ''::text THEN p.ds_usual
					ELSE it.ds_prod_vd
				END AS ds_prod,
			p.ncm_prod,
			p.vlr_pmc,
			p.ctr_pmc,
			0 AS ean_trib,
			medidas.ds_un AS cd_un_vd,
			it.qt_it,
			it.vlr_it,
			it.vlr_tot_it,
			it.vlr_desc_it,
			it.vlr_liq_it,
			it.cd_trib_fc,
			it.tx_icms_it,
			it.tx_red_it,
			it.st_it,
			it.tipo_imposto,
			it.cd_vend,
			cp.cd_nf_serie,
			cp.cd_usu,
			cp.vlr_imposto,
			cp.vlr_imposto_uf,
			cp.vlr_imposto_mun,
			it.vlr_desc_tot_rat,
			COALESCE(p.nr_cest, ''::character varying) AS nr_cest,
			COALESCE(p.nr_serv, ''::character varying) AS nr_serv,
			cp.hr_vd,
			cp.tipo_pbm,
			cp.tp_emis,
			pdv_cx.cod_ativacao_mfe,
			pdv_cx.signacmfe,
			COALESCE(it.perc_fcp, 0.0) AS perc_fcp,
			Coalesce(it.motivo_desonerado_icms,0) as motivo_desonerado_icms,
			Coalesce(it.icms_desonerado, 0) as icms_desonerado,
			Coalesce(it.vlr_icms_desonerado_it, 0.0) as vlr_icms_desonerado_it,
			cp.regime_tributario,
			it.origem_produto
		   FROM pdv_vd cp
			 JOIN pdv_vd_it it ON cp.cd_emp = it.cd_emp AND cp.cd_filial = it.cd_filial AND cp.cd_vd = it.cd_vd
			 JOIN est_prod p ON it.cd_emp = p.cd_emp AND it.cd_prod = p.cd_prod
			 JOIN pdv_cx ON cp.cd_emp = pdv_cx.cd_emp AND cp.cd_filial = pdv_cx.cd_filial AND cp.cd_cx = pdv_cx.cd_cx
			 LEFT JOIN est_prod_un_med medidas ON p.cd_emp = medidas.cd_emp AND p.cd_un_vd = medidas.cd_ctr_un;
			 
	RAISE NOTICE 'v_nfce Recriada.';
       
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();